﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Xml.Linq;
using System.Windows.Forms;

namespace SWAT_USB_App
{
    public struct Applications
    {
        public string Name;
        public bool Default;
        public string Group;
        public string[] SetupFileLocation;
    }
    public struct Drivers
    {
        public string Name;
        public string[] SetupFileLocation;
    }
    class SettingsParser
    {
        public static List<Applications> ApplicationsList = new List<Applications>();
        public static List<Drivers> DriversList = new List<Drivers>();
        public static int softwareFormWidth;
        public static int driverFormWidth;
        public static bool driverCheckForMatchingModel;
        private static string settingsFileLocation = Initialization.pathToSWATDrive + "USBSettings.xml";
        private static XElement Settings;

        public static bool settingsFileExist()
        {
            if (File.Exists(Initialization.pathToSWATDrive + "USBSettings.xml"))
                return true;
            else
                return false;
        }
        public static void readSettingsFile()
        {
            try
            {
                Debug.appendText("Parsing USBSettings.xml");
                // Clears the lists for software and drivers
                ApplicationsList.Clear();
                DriversList.Clear();

                Settings = XElement.Load(settingsFileLocation);

                // Reads program settings
                Debug.appendText("Reading program settings");
                XElement temp = Settings.Element("Program").Element("SoftwareFormWidth");
                if (temp == null)
                    Debug.appendText("Setting SoftwareFormWidth not found. Using default value of 210");
                else 
                    softwareFormWidth = int.Parse(Settings.Element("Program").Element("SoftwareFormWidth").Value);

                temp = Settings.Element("Program").Element("DriverFormWidth");
                if (temp == null)
                    Debug.appendText("Setting DriverFormWidth not found. Using default value of 180");
                else
                    driverFormWidth = int.Parse(Settings.Element("Program").Element("DriverFormWidth").Value);

                temp = Settings.Element("Program").Element("CheckForMatchingModel");
                if (temp == null)
                    Debug.appendText("Setting CheckForMatchingModel not found. Using default value of false");
                else
                    driverCheckForMatchingModel = bool.Parse(Settings.Element("Program").Element("CheckForMatchingModel").Value);

                // Reads the list of applications from the USBSettings.xml file into form_Software.softwareList
                Debug.appendText("Parsing list of applications");
                foreach (XElement elem in Settings.Elements("Applications").Elements("Application"))
                {
                    Debug.appendText("Adding application " + elem.Element("Name").Value);
                    // Creates new Applications struct for holding app info
                    Applications structElem = new Applications();
                    // Sets Name value
                    structElem.Name = elem.Element("Name").Value;
                    // Sets Default value
                    if (elem.Element("Default") != null)
                        if (elem.Element("Default").Value.ToLower() == "yes")
                            structElem.Default = true;
                    // Sets Group value
                    if (elem.Element("Group") != null)
                        structElem.Group = elem.Element("Group").Value;
                    // Sets SetupFileLocation value
                    string[] setupLocation = new string[elem.Element("Setup").Elements("Location").Count() * 2];
                    int counter = 0;
                    foreach (XElement element in elem.Elements("Setup").Elements("Location"))
                    {
                        Debug.appendText("Reading setup locations for application " + structElem.Name);
                        setupLocation[counter] = (string)element.Value;
                        setupLocation[counter + 1] = (string)element.Attribute("Args");
                        counter += 2;
                    }
                    structElem.SetupFileLocation = setupLocation;
                    // Adds created struct to struct list
                    ApplicationsList.Add(structElem);
                }

                // Reads the list of drivers from the USBSettings.xml file into form_Drivers.driverList
                Debug.appendText("Parsing list of drivers");
                foreach (XElement elem in Settings.Elements("Drivers").Elements("Driver"))
                {
                    Debug.appendText("Adding driver " + elem.Element("Name").Value);
                    // Creates new Drivers struct for holding driver info
                    Drivers structElem = new Drivers();
                    // Sets Name value
                    structElem.Name = elem.Element("Name").Value;
                    // Sets SetupFileLocation value
                    string[] setupLocation = new string[elem.Element("Setup").Elements("Location").Count() * 2];
                    int counter = 0;
                    foreach (XElement element in elem.Elements("Setup").Elements("Location"))
                    {
                        Debug.appendText("Reading setup locations for driver " + structElem.Name);
                        setupLocation[counter] = (string)element.Value;
                        setupLocation[counter + 1] = (string)element.Attribute("Args");
                        counter += 2;
                    }
                    structElem.SetupFileLocation = setupLocation;
                    // Adds created struct into struct list
                    DriversList.Add(structElem);
                }
            }
            catch (Exception e)
            {
                Debug.appendText("Exception Thrown: " + e.ToString());
                MessageBox.Show(e.ToString());
            }
        }
    }
}
